'use strict';
 (function($){
    $(function(){
        if( $('#code_editor_page_head').length ) {
            var editorSettings = wp.codeEditor.defaultSettings ? _.clone( wp.codeEditor.defaultSettings ) : {};
            editorSettings.codemirror = _.extend(
                {},
                editorSettings.codemirror,
                {
                    indentUnit: 2,
                    tabSize: 2
                }
            );
            
            var editor = wp.codeEditor.initialize( $('#code_editor_page_head'), editorSettings );
            
        }

        if( $('#code_editor_page_js').length ) {
            var editorSettings = wp.codeEditor.defaultSettings ? _.clone( wp.codeEditor.defaultSettings ) : {};
            editorSettings.codemirror = _.extend(
                {},
                editorSettings.codemirror,
                {
                    indentUnit: 2,
                    tabSize: 2,
                    mode: 'javascript',
                }
            );
            var editor = wp.codeEditor.initialize( 'code_editor_page_js', editorSettings );
            console.log(editor);
            
            document.getElementById('code_editor_page_js').addEventListener( 'change', function(ev) {
                console.log(ev);
                editor.codemirror.toTextArea();
            });
            
            setInterval( function() {
                editor.codemirror.save();
            }, 1000 )
            
            /*editor.on('change', editor => {
                globalContent = editor.getValue();
                console.log('changed');
            });*/
        }

        if( $('#code_editor_page_css').length ) {
            var editorSettings = wp.codeEditor.defaultSettings ? _.clone( wp.codeEditor.defaultSettings ) : {};
            editorSettings.codemirror = _.extend(
                {},
                editorSettings.codemirror,
                {
                    indentUnit: 2,
                    tabSize: 2,
                    mode: 'css',
                }
            );
            var editor = wp.codeEditor.initialize( $('#code_editor_page_css'), editorSettings );
        }
    });
 })(jQuery);