<?php
/**
 * Quadrantis Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Quadrantis
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_QUADRANTIS_VERSION', '1.2.0' );

/**
 * include updater code
 */
require get_stylesheet_directory() . '/updater.php';

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'quadrantis-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_QUADRANTIS_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

/**
 * Enqueue scripts
 */
function add_scripts_method() {
	wp_enqueue_script(
        'form-analytics',
        get_theme_file_uri( '/assets/js/form-analytics.js' ),
		array(), 
		'1.0.0',
		true
    );
}

add_action( 'wp_enqueue_scripts', 'add_scripts_method' );

/**
 * Create Custom post Types
 */
require_once( 'post-types/team.php' );
require_once( 'post-types/funds.php' );

/**
 * Create Custom taxonomies
 */
require_once( 'taxonomies/fund-type.php' );

/**
 * Remove os paragrafos desnecesarios
 */
add_filter( 'wpcf7_autop_or_not', '__return_false' );
add_filter('wpcf7_form_elements', function($content) {
    $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

    return $content;
});

/**
 * Custom thumbnails for team members
 */
add_image_size( 'team-thumb', 800, 800,  array( 'center', 'top' ) );


/**
 * Custom js page
 */
require_once( 'page-code-editor/page-code-editor.php' );
