<?php
/**
 * Theme updater
 * based on misha theme updater
 * 
 * @package Quadrantis
 * @since 1.2.0
 * 
 * @link https://github.com/rudrastyh/misha-theme-updater
 **/

add_filter( 'site_transient_update_themes', 'quadrantis_update_themes' );

function quadrantis_update_themes( $transient ) {
	// echo '<pre>-----';
	// print_r($transient);
	// echo '</pre>';

	// let's get the theme directory name
	// it will be "quadrantis"
	//$stylesheet = get_template();
    
    // print_r(wp_get_theme());
	// now let's get the thee version
	// but maybe it is better to hardcode it in a constant
	// $theme = wp_get_theme( $stylesheet );
	
	//$stylesheet = $theme->get( 'Name' );
	
	$stylesheet = basename( get_stylesheet_directory() );
	$theme = wp_get_theme();
	$version = $theme->get( 'Version' );
    
    //print_r(get_stylesheet_directory());
    // delete_transient ( 'quadrantis-theme-update-'.$version );
	if( false == $remote = get_transient( 'quadrantis-theme-update-'.$version ) ) {

		// connect to a remote server where the update information is stored
		$remote = wp_remote_get(
			'https://staging.quadrantiscapital.com/updates/info.json',
			array(
				'timeout' => 10,
				'headers' => array(
					'Accept' => 'application/json'
				)
			)
		);



		// do nothing if errors

		if(
			is_wp_error( $remote )
			|| 200 !== wp_remote_retrieve_response_code( $remote )
			|| empty( wp_remote_retrieve_body( $remote ) )
		) {
			return $transient;
		}

		$remote = json_decode( wp_remote_retrieve_body( $remote ) );



		if( ! $remote ) {
			return $transient; // who knows, meybe JSON is not valid
		}

		set_transient( 'quadrantis-theme-update-'.$version, $remote, DAY_IN_SECONDS );

	}

	// encode the response body

    
	$data = array(
		'theme' => $stylesheet,
		'url' => $remote->details_url,
		'requires' => $remote->requires,
		'requires_php' => $remote->requires_php,
		'new_version' => $remote->version,
		'package' => $remote->download_url,
	);
    
    // print_r($data);
    
	// check all the versions now
	if(
		$remote
		&& version_compare( $version, $remote->version, '<' )
		&& version_compare( $remote->requires, get_bloginfo( 'version' ), '<' )
		&& version_compare( $remote->requires_php, PHP_VERSION, '<' )
	) {
        if( empty( $transient->response ) ) {
        	$transient = new \stdClass();
        }
			$transient->response[ $stylesheet ] = $data;
        
	} else {

		$transient->no_update[ $stylesheet ] = $data;

	}

	// echo '<pre>2222';
	// print_r($transient);
	// echo '</pre>';



	return $transient;

}