<?php
add_action( 'init', 'fund_type_register_taxonomy' );
function fund_type_register_taxonomy() {
	$labels = [
		'name'                       => esc_html__( 'Fund Types', 'quadrantis' ),
		'singular_name'              => esc_html__( 'Fund Type', 'quadrantis' ),
		'menu_name'                  => esc_html__( 'Fund Types', 'quadrantis' ),
		'search_items'               => esc_html__( 'Search Fund Types', 'quadrantis' ),
		'popular_items'              => esc_html__( 'Popular Fund Types', 'quadrantis' ),
		'all_items'                  => esc_html__( 'All Fund Types', 'quadrantis' ),
		'parent_item'                => esc_html__( 'Parent Fund Type', 'quadrantis' ),
		'parent_item_colon'          => esc_html__( 'Parent Fund Type:', 'quadrantis' ),
		'edit_item'                  => esc_html__( 'Edit Fund Type', 'quadrantis' ),
		'view_item'                  => esc_html__( 'View Fund Type', 'quadrantis' ),
		'update_item'                => esc_html__( 'Update Fund Type', 'quadrantis' ),
		'add_new_item'               => esc_html__( 'Add New Fund Type', 'quadrantis' ),
		'new_item_name'              => esc_html__( 'New Fund Type Name', 'quadrantis' ),
		'separate_items_with_commas' => esc_html__( 'Separate fund types with commas', 'quadrantis' ),
		'add_or_remove_items'        => esc_html__( 'Add or remove fund types', 'quadrantis' ),
		'choose_from_most_used'      => esc_html__( 'Choose most used fund types', 'quadrantis' ),
		'not_found'                  => esc_html__( 'No fund types found.', 'quadrantis' ),
		'no_terms'                   => esc_html__( 'No fund types', 'quadrantis' ),
		'filter_by_item'             => esc_html__( 'Filter by fund type', 'quadrantis' ),
		'items_list_navigation'      => esc_html__( 'Fund Types list pagination', 'quadrantis' ),
		'items_list'                 => esc_html__( 'Fund Types list', 'quadrantis' ),
		'most_used'                  => esc_html__( 'Most Used', 'quadrantis' ),
		'back_to_items'              => esc_html__( '&larr; Go to Fund Types', 'quadrantis' ),
		'text_domain'                => esc_html__( 'quadrantis', 'quadrantis' ),
	];
	$args = [
		'label'              => esc_html__( 'Fund Types', 'quadrantis' ),
		'labels'             => $labels,
		'description'        => 'The type of investment funds.',
		'public'             => true,
		'publicly_queryable' => true,
		'hierarchical'       => false,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'show_in_nav_menus'  => true,
		'show_in_rest'       => true,
		'show_tagcloud'      => true,
		'show_in_quick_edit' => true,
		'show_admin_column'  => false,
		'query_var'          => true,
		'sort'               => false,
		'meta_box_cb'        => 'post_tags_meta_box',
		'rest_base'          => '',
		'rewrite'            => [
			'with_front'   => true,
			'hierarchical' => false,
		],
	];
	register_taxonomy( 'fund-type', ['funds'], $args );
}