<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Astra
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header(); ?>

<?php if ( astra_page_layout() == 'left-sidebar' ) : ?>

	<?php get_sidebar(); ?>

<?php endif ?>

	<div id="primary" <?php astra_primary_class(); ?>>


		<?php astra_primary_content_top(); ?>

		<article
		<?php
				echo astra_attr(
					'team',
					array(
						'id'    => 'post-' . get_the_id(),
						'class' => join( ' ', get_post_class() ),
					)
				);
				?>
		>
			<?php astra_entry_top(); ?>
				<div class="left-side meta-fields">
					<header class="entry-header <?php astra_entry_header_class(); ?>">

						<?php the_post_thumbnail('post-thumbnail', ['class' => 'team-thumb fade-in-image']); ?>

						<?php
						astra_the_title(
							'<h1 class="entry-title" ' . astra_attr(
								'article-title-content-page',
								array(
									'class' => '',
								)
							) . '>',
							'</h1>'
						);
						?>
						<p class="team-role">
							<?php 
							$company_role = get_field( "company_role" );
							echo ( $company_role ) ? $company_role : __("Collaborator", 'quadrantis');
							?>
						</p><!-- .team-role-->

						<div class="meta-fields">
							
							<?php 
							$main_expertise = get_field( "main_expertise" );

							if( $main_expertise ) {
								echo '<h2>Main Expertise</h2>';
								echo '<p>' . $main_expertise . '</p>';
							} 
							?>

							<h2>Contacts</h2>
							<div class="icons">

								<?php 
								$email_address = get_field( "email_address" );

if ( $email_address ) : ?>
									
									<a href="mailto:<?=$email_address?>?subject=Contacto através do website Quadrantis Capital para <?php the_title(); ?>" title="Email address" class="svg-icon email">
									<figure class="wp-block-uagb-image__figure">
									<img decoding="async" srcset="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='35' height='35' preserveAspectRatio='xMidYMid meet' viewBox='0 0 256 256'%3E%3Cpath fill='white' d='M224 52H32a4 4 0 0 0-4 4v136a12 12 0 0 0 12 12h176a12 12 0 0 0 12-12V56a4 4 0 0 0-4-4Zm-96 86.6L42.3 60h171.4ZM104.6 128L36 190.9V65.1Zm5.9 5.4l14.8 13.5a3.9 3.9 0 0 0 5.4 0l14.8-13.5l68.2 62.6H42.3Zm40.9-5.4L220 65.1v125.8Z'/%3E%3C/svg%3E " src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='35' height='35' preserveAspectRatio='xMidYMid meet' viewBox='0 0 256 256'%3E%3Cpath fill='white' d='M224 52H32a4 4 0 0 0-4 4v136a12 12 0 0 0 12 12h176a12 12 0 0 0 12-12V56a4 4 0 0 0-4-4Zm-96 86.6L42.3 60h171.4ZM104.6 128L36 190.9V65.1Zm5.9 5.4l14.8 13.5a3.9 3.9 0 0 0 5.4 0l14.8-13.5l68.2 62.6H42.3Zm40.9-5.4L220 65.1v125.8Z'/%3E%3C/svg%3E" alt="" title="" loading="lazy">
									</figure>
									</a>
								
								<?php endif; ?> 


								<?php 
								$linkedin = get_field( "linkedin" );

								if ( $linkedin ) : ?>
									
									<a href="<?=$linkedin?>" title="Linkedin Profile" class="svg-icon lkdin">
										<svg xmlns="http://www.w3.org/2000/svg" fill="var(--ast-global-color-5)" width="24" height="24" viewBox="0 0 24 24">
											<path d="M4.98 3.5c0 1.381-1.11 2.5-2.48 2.5s-2.48-1.119-2.48-2.5c0-1.38 1.11-2.5 2.48-2.5s2.48 1.12 2.48 2.5zm.02 4.5h-5v16h5v-16zm7.982 0h-4.968v16h4.969v-8.399c0-4.67 6.029-5.052 6.029 0v8.399h4.988v-10.131c0-7.88-8.922-7.593-11.018-3.714v-2.155z"/></svg>
									</a>

								<?php endif; ?>

							</div>
						
						</div><!-- .meta-fields-->

					</header><!-- .entry-header -->
				</div><!-- .left-side -->

				<div class="entry-content clear right-side"
					<?php
							echo astra_attr(
								'article-entry-content-page',
								array(
									'class' => '',
								)
							);
							?>
				>

					<?php astra_entry_content_before(); ?>

					<?php the_content(); ?>

					<?php astra_entry_content_after(); ?>

					<?php
						wp_link_pages(
							array(
								'before'      => '<div class="page-links">' . esc_html( astra_default_strings( 'string-single-page-links-before', false ) ),
								'after'       => '</div>',
								'link_before' => '<span class="page-link">',
								'link_after'  => '</span>',
							)
						);
						?>

				</div><!-- .entry-content .clear right-side -->

			<?php
				astra_edit_post_link(
					sprintf(
						/* translators: %s: Name of current post */
						esc_html__( 'Edit %s', 'astra' ),
						the_title( '<span class="screen-reader-text">"', '"</span>', false )
					),
					'<footer class="entry-footer"><span class="edit-link">',
					'</span></footer><!-- .entry-footer -->'
				);
				?>

			<?php astra_entry_bottom(); ?>

		</article><!-- #post-## -->

		<?php astra_entry_after(); ?>

		<?php astra_primary_content_bottom(); ?>

		<div class="bk-btn-team ifb-quadrantis">
			<div class="uagb-ifb-button-wrapper wp-block-button">
				<a href="<?php echo get_page_link(152) ?>" class="uagb-infobox-cta-link" target="_self" rel="noopener noreferrer" alt="">
					<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 256 512">
						<path d="M192 448c-8.188 0-16.38-3.125-22.62-9.375l-160-160c-12.5-12.5-12.5-32.75 0-45.25l160-160c12.5-12.5 32.75-12.5 45.25 0s12.5 32.75 0 45.25L77.25 256l137.4 137.4c12.5 12.5 12.5 32.75 0 45.25C208.4 444.9 200.2 448 192 448z">
						</path>
					</svg>
					<span class="uagb-inline-editing"><?php _e('Back to Team', 'quadrantis' ); ?></span>
				</a>
			</div>
			<br>
			<div class="site-primary-footer-wrap ast-builder-grid-row-container site-footer-focus-item ast-builder-grid-row-full ast-builder-grid-row-tablet-full ast-builder-grid-row-mobile-full ast-footer-row-stack ast-footer-row-tablet-stack ast-footer-row-mobile-stack" data-section="section-primary-footer-builder">
				<div class="ast-builder-grid-row-container-inner">
					<div class="ast-builder-footer-grid-columns site-primary-footer-inner-wrap ast-builder-grid-row">
						<div class="site-footer-primary-section-1 site-footer-section site-footer-section-1">
							<div class="footer-widget-area widget-area ast-flex site-footer-focus-item ast-footer-divider-element ast-footer-divider-1 ast-fb-divider-layout-horizontal" data-section="section-fb-divider-1">
								<div class="ast-divider-wrapper ast-divider-layout-horizontal">
									<div class="ast-builder-divider-element"></div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- .back-team 2 -->

		<!--<div class="back-team"> 
		<a href="https://quadrantis.devfloat.pt/wp/team_temp/">
			 back-team Archive link <a href="<?=get_post_type_archive_link( 'team' )?>"> 
				<?php _e('&lt; back to team', 'quadrantis' ); ?>
			</a>
		</div> .back-team (original) -->

	</div><!-- #primary -->
	

<?php if ( astra_page_layout() == 'right-sidebar' ) : ?>

	<?php get_sidebar(); ?>

<?php endif ?>

<?php get_footer(); ?>
