<?php
add_action( 'init', 'funds_register_post_type' );
function funds_register_post_type() {
	$labels = [
		'name'                     => esc_html__( 'Investment Funds', 'quadrantis' ),
		'singular_name'            => esc_html__( 'Investment Fund', 'quadrantis' ),
		'add_new'                  => esc_html__( 'Add New', 'quadrantis' ),
		'add_new_item'             => esc_html__( 'Add New Investment Fund', 'quadrantis' ),
		'edit_item'                => esc_html__( 'Edit Investment Fund', 'quadrantis' ),
		'new_item'                 => esc_html__( 'New Investment Fund', 'quadrantis' ),
		'view_item'                => esc_html__( 'View Investment Fund', 'quadrantis' ),
		'view_items'               => esc_html__( 'View Investment Funds', 'quadrantis' ),
		'search_items'             => esc_html__( 'Search Investment Funds', 'quadrantis' ),
		'not_found'                => esc_html__( 'No investment funds found.', 'quadrantis' ),
		'not_found_in_trash'       => esc_html__( 'No investment funds found in Trash.', 'quadrantis' ),
		'parent_item_colon'        => esc_html__( 'Parent Investment Fund:', 'quadrantis' ),
		'all_items'                => esc_html__( 'All Investment Funds', 'quadrantis' ),
		'archives'                 => esc_html__( 'Investment Fund Archives', 'quadrantis' ),
		'attributes'               => esc_html__( 'Investment Fund Attributes', 'quadrantis' ),
		'insert_into_item'         => esc_html__( 'Insert into investment fund', 'quadrantis' ),
		'uploaded_to_this_item'    => esc_html__( 'Uploaded to this investment fund', 'quadrantis' ),
		'featured_image'           => esc_html__( 'Featured image', 'quadrantis' ),
		'set_featured_image'       => esc_html__( 'Set featured image', 'quadrantis' ),
		'remove_featured_image'    => esc_html__( 'Remove featured image', 'quadrantis' ),
		'use_featured_image'       => esc_html__( 'Use as featured image', 'quadrantis' ),
		'menu_name'                => esc_html__( 'Investment Funds', 'quadrantis' ),
		'filter_items_list'        => esc_html__( 'Filter investment funds list', 'quadrantis' ),
		'filter_by_date'           => esc_html__( '', 'quadrantis' ),
		'items_list_navigation'    => esc_html__( 'Investment Funds list navigation', 'quadrantis' ),
		'items_list'               => esc_html__( 'Investment Funds list', 'quadrantis' ),
		'item_published'           => esc_html__( 'Investment Fund published.', 'quadrantis' ),
		'item_published_privately' => esc_html__( 'Investment Fund published privately.', 'quadrantis' ),
		'item_reverted_to_draft'   => esc_html__( 'Investment Fund reverted to draft.', 'quadrantis' ),
		'item_scheduled'           => esc_html__( 'Investment Fund scheduled.', 'quadrantis' ),
		'item_updated'             => esc_html__( 'Investment Fund updated.', 'quadrantis' ),
		'text_domain'              => esc_html__( 'quadrantis', 'quadrantis' ),
	];
	$args = [
		'label'               => esc_html__( 'Investment Funds', 'quadrantis' ),
		'labels'              => $labels,
		'description'         => '',
		'public'              => true,
		'hierarchical'        => true,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'show_ui'             => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'show_in_rest'        => true,
		'query_var'           => true,
		'can_export'          => true,
		'delete_with_user'    => true,
		'has_archive'         => false,
		'rest_base'           => '',
		'show_in_menu'        => true,
		'menu_position'       => '',
		'menu_icon'           => 'dashicons-building',
		'capability_type'     => 'post',
		'supports'            => ['title', 'editor', 'thumbnail', 'excerpt', 'custom-fields', 'revisions', 'page-attributes', 'author'],
		'taxonomies'          => ['fund-type'],
		'rewrite'             => [
			'with_front' => false,
		],
	];

	register_post_type( 'funds', $args );
}