<?php
add_action( 'init', 'team_register_post_type' );
function team_register_post_type() {
	$labels = [
		'name'                     => esc_html__( 'Team Members', 'quadrantis' ),
		'singular_name'            => esc_html__( 'Team Member', 'quadrantis' ),
		'add_new'                  => esc_html__( 'Add New', 'quadrantis' ),
		'add_new_item'             => esc_html__( 'Add New Team Member', 'quadrantis' ),
		'edit_item'                => esc_html__( 'Edit Team Member', 'quadrantis' ),
		'new_item'                 => esc_html__( 'New Team Member', 'quadrantis' ),
		'view_item'                => esc_html__( 'View Team Member', 'quadrantis' ),
		'view_items'               => esc_html__( 'View Team Members', 'quadrantis' ),
		'search_items'             => esc_html__( 'Search Team Members', 'quadrantis' ),
		'not_found'                => esc_html__( 'No team members found.', 'quadrantis' ),
		'not_found_in_trash'       => esc_html__( 'No team members found in Trash.', 'quadrantis' ),
		'parent_item_colon'        => esc_html__( 'Parent Team Member:', 'quadrantis' ),
		'all_items'                => esc_html__( 'All Team Members', 'quadrantis' ),
		'archives'                 => esc_html__( 'Team Member Archives', 'quadrantis' ),
		'attributes'               => esc_html__( 'Team Member Attributes', 'quadrantis' ),
		'insert_into_item'         => esc_html__( 'Insert into team member', 'quadrantis' ),
		'uploaded_to_this_item'    => esc_html__( 'Uploaded to this team member', 'quadrantis' ),
		'featured_image'           => esc_html__( 'Featured image', 'quadrantis' ),
		'set_featured_image'       => esc_html__( 'Set featured image', 'quadrantis' ),
		'remove_featured_image'    => esc_html__( 'Remove featured image', 'quadrantis' ),
		'use_featured_image'       => esc_html__( 'Use as featured image', 'quadrantis' ),
		'menu_name'                => esc_html__( 'Team Members', 'quadrantis' ),
		'filter_items_list'        => esc_html__( 'Filter team members list', 'quadrantis' ),
		'filter_by_date'           => esc_html__( '', 'quadrantis' ),
		'items_list_navigation'    => esc_html__( 'Team Members list navigation', 'quadrantis' ),
		'items_list'               => esc_html__( 'Team Members list', 'quadrantis' ),
		'item_published'           => esc_html__( 'Team Member published.', 'quadrantis' ),
		'item_published_privately' => esc_html__( 'Team Member published privately.', 'quadrantis' ),
		'item_reverted_to_draft'   => esc_html__( 'Team Member reverted to draft.', 'quadrantis' ),
		'item_scheduled'           => esc_html__( 'Team Member scheduled.', 'quadrantis' ),
		'item_updated'             => esc_html__( 'Team Member updated.', 'quadrantis' ),
		'text_domain'              => esc_html__( 'quadrantis', 'quadrantis' ),
	];
	$args = [
		'label'               => esc_html__( 'Team Members', 'quadrantis' ),
		'labels'              => $labels,
		'description'         => '',
		'public'              => true,
		'hierarchical'        => true,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'show_ui'             => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'show_in_rest'        => true,
		'query_var'           => true,
		'can_export'          => true,
		'delete_with_user'    => true,
		'has_archive'         => false,
		'rest_base'           => '',
		'show_in_menu'        => true,
		'menu_position'       => '',
		'menu_icon'           => 'dashicons-businessman',
		'capability_type'     => 'page',
		'supports'            => ['title', 'editor', 'thumbnail', 'excerpt', 'custom-fields', 'revisions'],
		'taxonomies'          => [],
		'rewrite'             => [
			'with_front' => false,
		],
	];

	register_post_type( 'team', $args );
}

// Register hierarchy Taxonomy
function hierarchy_taxonomy() {

	$labels = array(
		'name'                       => _x( 'Hierarchies', 'Hierarchy General Name', 'quadrantis' ),
		'singular_name'              => _x( 'Hierarchy', 'Hierarchy Singular Name', 'quadrantis' ),
		'menu_name'                  => __( 'Hierarchy', 'quadrantis' ),
		'all_items'                  => __( 'All Items', 'quadrantis' ),
		'parent_item'                => __( 'Parent Item', 'quadrantis' ),
		'parent_item_colon'          => __( 'Parent Item:', 'quadrantis' ),
		'new_item_name'              => __( 'New Item Name', 'quadrantis' ),
		'add_new_item'               => __( 'Add New Item', 'quadrantis' ),
		'edit_item'                  => __( 'Edit Item', 'quadrantis' ),
		'update_item'                => __( 'Update Item', 'quadrantis' ),
		'view_item'                  => __( 'View Item', 'quadrantis' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'quadrantis' ),
		'add_or_remove_items'        => __( 'Add or remove items', 'quadrantis' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'quadrantis' ),
		'popular_items'              => __( 'Popular Items', 'quadrantis' ),
		'search_items'               => __( 'Search Items', 'quadrantis' ),
		'not_found'                  => __( 'Not Found', 'quadrantis' ),
		'no_terms'                   => __( 'No items', 'quadrantis' ),
		'items_list'                 => __( 'Items list', 'quadrantis' ),
		'items_list_navigation'      => __( 'Items list navigation', 'quadrantis' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => false,
		'show_in_rest'				 => true,
	);
	register_taxonomy( 'hierarchy', array( 'team' ), $args );

}
add_action( 'init', 'hierarchy_taxonomy', 0 );