<?php

add_action( 'admin_enqueue_scripts', 'add_page_scripts_enqueue_script' );

/**
 * Enqueue the Code Editor and JS
 *
 * @param string $hook
 */
function add_page_scripts_enqueue_script( $hook ) {
    global $post;

    if ( ! $post ) { return; }

    if ( ! 'page' === $post->post_type || ! 'funds' === $post->post_type ) { return; }
 
    if( 'post.php' === $hook || 'post-new.php' === $hook ) {
        wp_enqueue_code_editor( 
            array( 
                'type' => 'text/html', 
                'codemirror' => array(
                    'autoRefresh' => true
                )
            ) 
        );
        // wp_enqueue_script( 'js-code-editor', plugin_dir_url( __FILE__ ) . '/page-code-editor.js', array( 'jquery' ), '', true );
        wp_enqueue_script( 'js-code-editor', get_theme_file_uri( '/page-code-editor/page-code-editor.js' ), array( 'jquery' ), '', true );
    }
}

add_action( 'add_meta_boxes', 'add_page_scripts' );

/**
 * Register the metabox
 */
function add_page_scripts() {
    add_meta_box( 'page-scripts', __( 'Page Scripts', 'quadrantis' ), 'add_page_metabox_scripts_html', ['page', 'funds'], 'advanced' );
}

/**
 * Meta box display callback.
 *
 * @param WP_Post $post Current post object.
 */
function add_page_metabox_scripts_html( $post ) {
    $post_id = $post->ID;
    $page_scripts = get_post_meta( $post_id, 'page_scripts', true );
    if ( ! $page_scripts ) {
        $page_scripts = array(
            'js'        => '',
        );
    }
    ?>

    <fieldset>
        <h3>JavaScript 4 wisep</h3>
        <p class="description">Add javascript without the script tag.</p>
        <textarea id="code_editor_page_js" rows="5" name="page_scripts[js]" class="widefat textarea"><?php echo wp_unslash( $page_scripts['js'] ); ?></textarea>   
    </fieldset>

    <?php
}

/**
 * Save meta box content.
 *
 * @param int $post_id Post ID
 */
function page_scripts_save_meta_box( $post_id ) {

    if( defined( 'DOING_AJAX' ) ) {
        return;
    }

    if( isset( $_POST['page_scripts'] ) ) {
    
        $scripts = $_POST['page_scripts'];

        update_post_meta( $post_id, 'page_scripts', $scripts );
    }
 
 
}

add_action( 'save_post', 'page_scripts_save_meta_box' );

add_action( 'wp_head', 'page_scripts_add_head' );

/**
 * Put scripts in the head.
 */
function page_scripts_add_head() {
    $post_id = get_the_id();
    $page_scripts = get_post_meta( $post_id, 'page_scripts', true );
    if ( ! $page_scripts ) { return; }
    if ( isset( $page_scripts['page_head'] ) && '' !== $page_scripts['page_head'] ) {
        echo wp_unslash( $page_scripts['page_head'] );
    }
    if ( isset( $page_scripts['js'] ) && '' !== $page_scripts['js'] ) {
        echo '<script>' . wp_unslash( $page_scripts['js'] ) . '</script>';
    }
    if ( isset( $page_scripts['css'] ) && '' !== $page_scripts['css'] ) {
        echo '<style>' . wp_unslash( $page_scripts['css'] ) . '</style>';
    }
}